//------------------------------------------------------------------------------
// <copyright file="ProtocolFamily.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
//------------------------------------------------------------------------------

namespace System.Net.Sockets
{

    /// <devdoc>
    ///    <para>
    ///       Specifies the type of protocol that an instance of the <see cref='System.Net.Sockets.Socket'/>
    ///       class can use.
    ///    </para>
    /// </devdoc>
    public enum ProtocolFamily {
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Unknown             = AddressFamily.Unknown,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Unspecified         = AddressFamily.Unspecified,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Unix                = AddressFamily.Unix,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        InterNetwork        = AddressFamily.InterNetwork,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        ImpLink             = AddressFamily.ImpLink,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Pup                 = AddressFamily.Pup,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Chaos               = AddressFamily.Chaos,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        NS                  = AddressFamily.NS,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Ipx                 = AddressFamily.Ipx,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Iso                 = AddressFamily.Iso,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Osi                 = AddressFamily.Osi,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Ecma                = AddressFamily.Ecma,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        DataKit             = AddressFamily.DataKit,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Ccitt               = AddressFamily.Ccitt,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Sna                 = AddressFamily.Sna,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        DecNet              = AddressFamily.DecNet,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        DataLink            = AddressFamily.DataLink,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Lat                 = AddressFamily.Lat,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        HyperChannel        = AddressFamily.HyperChannel,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        AppleTalk           = AddressFamily.AppleTalk,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        NetBios             = AddressFamily.NetBios,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        VoiceView           = AddressFamily.VoiceView,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        FireFox             = AddressFamily.FireFox,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Banyan              = AddressFamily.Banyan,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Atm                 = AddressFamily.Atm,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        InterNetworkV6      = AddressFamily.InterNetworkV6,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Cluster             = AddressFamily.Cluster,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Ieee12844           = AddressFamily.Ieee12844,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Irda                = AddressFamily.Irda,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        NetworkDesigners    = AddressFamily.NetworkDesigners,
        /// <devdoc>
        ///    <para>[To be supplied.]</para>
        /// </devdoc>
        Max                 = AddressFamily.Max,

    }; // enum ProtocolFamily


} // namespace System.Net.Sockets
